---
language: kotlin
exerciseType: 2
---

# --description--

In Kotlin abbiamo anche il ciclo `forEach`.
Esso richiama la chiusura (_closure_) fornita su ogni elemento della sequenza nello stesso ordine di un ciclo `for-in`:

```kotlin
// questa è una lista, la vedremo presto
val numeri = listOf(1, 3, 5, 7, 9) 
numeri.forEach {
    println(it)
}
```

L'uso del metodo `forEach` si distingue da un ciclo `for-in` per due aspetti importanti:
1. Le istruzioni `break` o `continue` non possono essere usate per uscire dalla chiamata corrente della chiusura del corpo o per saltare le chiamate successive. (_In realtà è possibile con le annotazioni, ma è un argomento un po' più complesso che non vedremo ora).
2. L'uso dell'istruzione `return` nel corpo della chiusura farà uscire solo dalla chiusura e non l'ambito esterno, e non salterà le chiamate successive.

# --instructions--

Completa il codice per stampare i seguenti numeri `(3, 24, 9, 12, 18)` utilizzando un ciclo `forEach`

# --seed--

```kotlin
val numeri = listOf(3, 24, 9, 12, 18) 
[/].[/] {
    println([/])
}
```

# --answers--

- for
- numeri
- forEach
- num
- it

# --solutions--

```kotlin
val numeri = listOf(3, 24, 9, 12, 18) 
numeri.forEach {
    println(it)
}
```

# --output--

3
24
9
12
18
