---
language: kotlin
exerciseType: 2
---

# --description--

Il _passo_ predefinito di un intervallo è __1__, ma è possibile impostare esplicitamente un altro valore.

È possibile definire il __passo__ del ciclo `for` utilizzando la parola chiave `step`.

```kotlin
for (i in 1..10 step 2) {
    println(i)
}
// stampa 1, 3, 5, 7, 9
```

Come si può vedere, il blocco di codice viene eseguito con un passo di _2_ invece che di _1_, cambiando completamente il nostro output.

# --instructions--

Completa il ciclo `for` nel codice seguente per ottenere questo risultato: `10, 8, 6, 4, 2`

# --seed--

```kotlin
for (i in 10 [/] 1 [/] 2) {
    println(i)
}
```

# --answers--

- loop
-  until 
- ..
- ..<
- downTo
- step

# --solutions--

```kotlin
for (i in 10 downTo 1 step 2) {
    println(i)
}
```

# --output--

10
8
6
4
2
