---
language: javascript
exerciseType: 2
---

# --description--

Spesso in programmazione, e' necessario ripetere un blocco di codice, ad esempio:
```javascript
console.log("2 secondi");
console.log("3 secondi");
console.log("4 secondi");
console.log("5 secondi");
```
Questo produce il seguente output:
```javascript
2 secondi
3 secondi
4 secondi
5 secondi
```
Ovviamente, per lunghe dichiarazioni passeremmo molto tempo a scrivere il codice, ma fortunatamente possiamo usare i cicli.
Usiamo il ciclo `while`, in modo da ottenene lo stesso output di sopra.
```javascript
var contatore = 2;
while (contatore <= 5) {
    console.log(`${contatore} secondi`);
    contatore += 1;
}
```
Quindi abbiamo creato una variabile `contatore` assegnandole `2`, il valore iniziale.
Poi abbiamo usato la parola chiave `while` che eseguirà il blocco di codice finche' la condizione `contatore <= 5` è `true`.
All'interno del blocco di codice, **NON** dovremo dimenticare la linea di codice `contatore += 1`.
In quanto incrementa il valore del `contatore`, altrimenti il nostro ciclo sarà infinito

# --instructions--

Riempire gli spazi vuoti con il ciclo `while` per ripetere il blocco di codice

# --seed--

```javascript
[/] (true) {
    console.log("ripeti");
}
```

# --answers--

- while
- "while"
- for
- loop

# --solutions--

```javascript
while (true) {
    console.log("ripeti");
}
```

# --output--

ripeti
ripeti
ripeti
ripeti
...
