---
language: javascript
exerciseType: 2
---

# --description--

Esattamente come per gli array, possiamo fare un ciclo per gli elementi del dizionario usando il metodo `Object.entries()`.
```javascript
var utente = {"nome": "John", "cognome": "Hood", "eta": 30};
for (const [chiave, valore] of Object.entries(utente)) {
    console.log(`${chiave}: ${valore}`);
}
```

# --instructions--

Passa in rassegna tutti gli elementi del dizionario

# --seed--

```javascript
var utente = {"nome": "John", "cognome": "Hood", "eta": 30};
[/] (const [[/], [/]] of Object.[/](utente)) {
  console.log(`${key}: [/]`);
}
```

# --answers--

- key
- value
- value
- utente
- "utente"
- \(value)
- ${value}
- entries
- for

# --solutions--

```javascript
var utente = {"nome": "John", "cognome": "Hood", "eta": 30};
for (const [key, value] of Object.entries(utente)) {
  console.log(`${key}: ${value}`);
}
```

# --output--

nome: John
cognome: Hood
eta: 30
