---
language: dart
exerciseType: 1
---

# --description--

Dart supporta due tipi diversi di "_variabili_" il cui valore non cambia mai. Vengono dichiarate con le parole chiave `const` e `final`.
Iniziamo vedendo che cosa si intende per `const`.

## const (costanti)

Le variabili il cui valore valore puoi modificare sono conosciute come __dato mutabile__. I dati mutabili vengono spesso usati smisuratamente e possono presentare dei problemi. È facile perdere traccia di tutti i punti nel codice che possono modificare il valore di una variabile.

Per questa ragione, dovresti usare le constanti invece delle variabili quando possibile. Queste variabili che non possono cambiare valore vengono anche chiamate __dato immutabile__.

Per creare una constante in Dart usiamo la parola chiave `const`:

```dart
const numero = 5;
```

Esattamente come `var`, Dart con la __type inference__ determina che `numero` è di tipo `int`.

# --instructions--

Dichiara una costante `nome` ed assegnale il tuo nome.

# --before-asserts--

```dart
import 'package:dart_runner/main.dart';
import 'package:test/test.dart';

void main() {
  group('MainTest -', () {
```

# --asserts--

`nome` deve essere una constante.

```dart
  test('test1', () {
    expect(nome, TypeMatcher<String>(), reason: '--err-t1--');
  });
```

# --after-asserts--

```dart
  }, timeout: Timeout(const Duration(seconds: 1)));
}
```

# --solutions--

```dart
const nome = "Ale"; // qualsiasi nome va bene
```
