---
language: dart
exerciseType: 1
---

# --description--

Dart supporta la __type inference__ (inferenza del tipo).
Non è necessario indicare il tipo di una variabile in quanto Dart riesce ad inferirne il tipo.
La parola chiave `var` indica a Dart di usare il tipo piú appropriato.

```dart
var numero = 5;
```

Non è necessario dire a Dart che il numero `5` è di tipo `int`.
Dart inferisce il tipo e rende `numero` di tipo `int`.

# --instructions--

Inizializza la variable `x` con il numero `3.14159` e lascia che Dart inferisca il tipo.

# --before-seed--

```dart
dynamic number() {
```

# --after-seed--

```dart
  return x;
}
```

# --before-asserts--

```dart
import 'package:dart_runner/main.dart';
import 'package:test/test.dart';

void main() {
  group('MainTest -', () {
```

# --asserts--

`x` deve essere uguale a `3.14159`.

```dart
  test('test1', () {
    expect(number(), 3.14159, reason: '--err-t1--');
  });
```

`x` deve essere di tipo `double`

```dart
  test('test2', () {
    expect(number(), TypeMatcher<double>(), reason: '--err-t2--');
  });
```

# --after-asserts--

```dart
  }, timeout: Timeout(const Duration(seconds: 1)));
}
```

# --solutions--

```dart
var x = 3.14159;
```
