---
language: dart
exerciseType: 1
---

# --description--

Volendo, se ti piace vivere rischiando, possiamo ignorare completamente la __type-safety__ del linguaggio usando il tipo `dynamic`.
Questo ti permette di assegnare qualsiasi tipo di valore alla variabile.

```dart
dynamic numero;
numero = 1; // OK
numero = 3.14159; // OK
numero = '10'; // OK
```

Questo approccio è fortemente sconsigliato in quanto gli errori non vengono piú intercettati dall'_analyzer_ del codice, ma solo _runtime_ (quando il programma è in esecuzione).

# --instructions--

Inizializza la variable `x` con il numero `10` ed il tipo `dynamic`.
Aggiorna la variabile con la stringa `ciao`.

# --before-seed--

```dart
dynamic number() {
```

# --after-seed--

```dart
  return x;
}
```

# --before-asserts--

```dart
import 'package:dart_runner/main.dart';
import 'package:test/test.dart';

void main() {
  group('MainTest -', () {
```

# --asserts--

`x` deve essere uguale a `"ciao"`.

```dart
  test('test1', () {
    expect(number(), "ciao", reason: '--err-t1--');
  });
```

`x` deve essere di tipo `dynamic`

```dart
  test('test2', () {
    expect(number(), TypeMatcher<dynamic>(), reason: '--err-t2--');
  });
```

# --after-asserts--

```dart
  }, timeout: Timeout(const Duration(seconds: 1)));
}
```

# --solutions--

```dart
dynamic x = 10;
x = "ciao";
```
