---
language: dart
exerciseType: 1
---

# --description--

Dart è un linguaggio __type-safe__ (sicurezza rispetto ai tipi).
Questo significa che quando assegni ad una variabile un tipo, non lo potrai piú modificare dopo. Ecco un esempio:

```dart
int numeroIntero = 1;
numeroIntero = 3.14159; // Errore
```

`3.14159` è di tipo `double`, ma hai già definito `numeroIntero` col tipo `int`.

Ovviamente, ogni tanto potrebbe essere utile assegnare tipo correlati alla stessa variabile. Per esempio potresti volere una variabile `numero` che accetta sia numeri `int`eri che `double`, come qui:
```dart
num numero;
numero = 1; // OK
numero = 3.14159; // OK
numero = '10'; // Errore
```

Sia `int` che `double` estendono `num`, quindi entrambi i tipi sono accettati.
Invece se proviamo ad assegnare una `String`a il compilatore ci restituisce un errore.

# --instructions--

Inizializza la variable `x` con il numero `15` ed il tipo `num`
Aggiorna la variabile con il numero `3.14159`

# --before-seed--

```dart
dynamic number() {
```

# --after-seed--

```dart
  return x;
}
```

# --before-asserts--

```dart
import 'package:dart_runner/main.dart';
import 'package:test/test.dart';

void main() {
  group('MainTest -', () {
```

# --asserts--

`x` deve essere uguale a `3.14159`.

```dart
  test('test1', () {
    expect(number(), 3.14159, reason: '--err-t1--');
  });
```

`x` deve essere di tipo `num`

```dart
  test('test2', () {
    expect(number(), TypeMatcher<num>(), reason: '--err-t2--');
  });
```

# --after-asserts--

```dart
  }, timeout: Timeout(const Duration(seconds: 1)));
}
```

# --solutions--

```dart
num x = 15;
x = 3.14159;
```
