---
language: dart
exerciseType: 1
---

# --description--

Spesso ti troverai nella situazione di voler usare una costante ma non conosci il valore a tempo di compilazione. Conoscerai il valore solo dopo che il programma ha iniziato la sua esecuzione.
Questo tipo di costante è conosciuta come __runtime constant__ (costante a tempo di esecuzione).

In Dart `const` viene usato solo per __compile-time constants__ (costanti a tempo di compilazione) per valori che possono essere determinati dal compilatore prima dell'esecuzione del programma.

Se non puoi creare una variabile costante in quanto non ne conosci il valore a tempo di compilazione, allora devi usare la parole chiave `final` per rendere la variabile una __runtime constant__.

Ci sono molte ragioni per cui non puoi conoscere il valore di una variabile prima di eseguire il programma. Per esempio, dovresti dover ottenere il valore dal server, oppure chiederlo all'utente.

# --instructions--

Dichiara una __runtime costant__ `eta` ed assegnale la tua età.

# --before-asserts--

```dart
import 'package:dart_runner/main.dart';
import 'package:test/test.dart';

void main() {
  group('MainTest -', () {
```

# --asserts--

`eta` deve essere una __runtime constant__.

```dart
  test('test1', () {
    expect(eta, TypeMatcher<int>(), reason: '--err-t1--');
  });
```

# --after-asserts--

```dart
  }, timeout: Timeout(const Duration(seconds: 1)));
}
```

# --solutions--

```dart
final eta = 26; // qualsiasi età va bene
```
