---
language: dart
exerciseType: 1
---

# --description--

Le variabili sono contenitori per salvare valori.
Ogni variable in Dart è un oggetto (`Object`).
Per creare una variabile, dobbiamo darle un __nome__ tenendo in considerazione il fatto che non deve contenere spazi.
Dai un'occhiata a quanto segue:

```dart
int numero = 1;
```

Questa dichiarazione dichiara una variable chiamata `numero` di tipo `int`.
Poi imposta il valore della variabile al numero `1`.
La parte della dichiarazione `int` è conosciuta come __type annotation__ (tipo di annotazione), ed indica a Dart in modo esplicito il tipo della variabile.

# --instructions--

Assegna alla variable `y` il valore `2`.

# --before-asserts--

```dart
import 'package:dart_runner/main.dart';
import 'package:test/test.dart';

void main() {
  group('MainTest -', () {
```

# --asserts--

`y` deve essere uguale a `2`

```dart
  test('test1', () {
    expect(y, 2, reason: '--err-t1--');
  });
```

`y` deve essere di tipo `int`

```dart
  test('test2', () {
    expect(y, TypeMatcher<int>(), reason: '--err-t2--');
  });
```

# --after-asserts--

```dart
  }, timeout: Timeout(const Duration(seconds: 1)));
}
```

# --solutions--

```dart
int y = 2;
```
