---
language: dart
exerciseType: 2
---

# --description--

Fino ad adesso abbiamo visto gli operatori usati indipendentemente su numeri interi o decimali.
Cosa succede se hai un numero intero e lo devi moltiplicare con un numero decimale?
Vediamo un esempio:
```dart
const raggio = 5;
const pi = 3.14;
const circonferenza = 2 * pi * raggio;
```

`raggio` è di tipo `int` mentre `pi` è di tipo `double`. Quale sarà il tipo di `circonferenza`?
Dart assegnerà il tipo `double` alla variabile `circonferenza`. Questa è la scelta più sicura in quanto se l'avesso reso di tipo `int` avrebbe potuto causare una perdita di precisione.

Se vuoi un `int` come risultato, devi effettuare la conversione in modo esplicito:
```dart
const circonferenza = (2 * pi * raggio).toInt();
```

Le parentesi tonde indicano a Dart di moltiplicare prima, e poi di predendere il risultato e convertirlo in un valore intero. Purtroppo all'analyzer questo codice non piacerà:
> Const variables must be initialized with a constant value.

Il problema è che il metodo `toInt` è un metodo eseguibili solo a runtime. Questo significa che la variabile `circonferenza` non può essere determinata a tempo di compilazione, quindi non è possibile che la variabile sia costante. Per risolvere sostituisci `const` con `final`:

```dart
final circonferenza = (2 * pi * raggio).toInt();
```

Ora `circonferenza` è una variabile __runtime constant__ di tipo `int`.

# --instructions--

Crea una variabile __runtime constant__ di tipo `int`.

# --seed--

```dart
const pagaOraria = 10.40;
const oreLavorate = 8;
[/] costoTotale = ([/] * oreLavorate).[/];
print(costoTotale);
```

# --answers--

- final
- Const
- const
- pagaOraria
- toInt()
- [
- {

# --solutions--

```dart
const pagaOraria = 10.40;
const oreLavorate = 8;
final costoTotale = (pagaOraria * oreLavorate).toInt();
print(costoTotale);
```

# --output--

83
