---
language: dart
exerciseType: 2
---

# --description--

A volte ti troverai nella situazione di avere un tipo, ma doverlo convertire in un altro.
Potresti essere tentato dal fare:

```dart
var intero = 5;
var decimale = 3.14;
intero = decimale;
```

Ma Dart si lamenterà e ti restituirá l'errore:
> Error: A value of type 'double' can't be assigned to a variable of type 'int'.

Alcuni linguaggi di programmazione non sono cosí restrittivi e silentemente effettueranno la conversione. L'esperienza dimostra che questo tipo di conversione implicita silente è una fonte frequente di bug e problemi di performance. Dart ha disabilitato questa funzionalità per evitare questi problemi.

Ricorda, i computer fanno affidamento sui programmatori per capire cosa fare. In Dart questo include l'essere espliciti sul tipo di conversione.

Invece di aspettarti una conversione implicita da Dart, devi dire in modo esplicito che vuoi che Dart ti converta il tipo. Ecco come convertire un numero `double` in uno `int`:
```dart
var intero = decimale.toInt();
```

L'assegnazione dice a Dart, in modo inequivocabile, che vuoi convertire dal tipo originale `double` al nuovo tipo `double`.

> NOTA: In questo caso, assegnare un valore decimale ad un intero fa perdere la precisione. La variabile `intero` si ritrova il valore __3__ invece di __3.14__. Questo è il motivo per cui è importante essere espliciti. Dart vuole essere sicuro di quello che stai facendo e ti mette al corrente che perderai delle informazioni effettuando la conversione.

# --instructions--

Converti la variabile `numero` in una stringa

# --seed--

```dart
const numero = 5;
print([/][/][/]);
```

# --answers--

- numero
- .
- toString()
- toStr()
- toString
- string
- as String

# --solutions--

```dart
const numero = 5;
print(numero.toString());
```

# --output--

5
