---
language: dart
exerciseType: 2
---

# --description--

A volte potresti avere una variabile con un tipo generico, ma ti serve una funzionalità presente solo in un sottotipo. Se sei sicuro che il tipo della variabile è il sottotipo che ti serve, allora puoi usare la parola chiave `as` per modificarne il tipo. Questa prodecura è anche conosciuta come __type casting__, ecco un esempio:

```dart
num numero = 3;
```

Ipotizziamo di voler controllare se il numero è pari, e la funzionalità in questione è presente solo sul sotto tipo `int`.
```dart
print(numero.isEven);
```

Il codice qui sopra ti dovrebbe restituire un errore del tipo:
> The getter `isEven` isn't defined for the type 'num'.

Il tipo `num` è un tipo troppo generico per sapere se un numero è pari o dispari. Solo i numeri interi possono essere pari o dispari.
Il problema si presenta se `num` contiene un valore `double`, in quanto `num` include entrambi i tipi `double` e `int`. In questo caso, siamo sicuri che __3__ è un numero intero, quindi possiamo fare il casting a `int`

```dart
final intero = numero as int;
print(intero.isEven); // false
```

La parola chiave `as` fa si che il compilatore riconosce la variabile `intero` con il tipo `int`. Questo permette di usare la proprietà `isEven` che è presente sui numeri interi. Dato che il numero __3__ non è intero, il risultato è false.

Devi stare attendo quando fai casting. Se casti erroneamente il tipo otterrai un errore runtime:
```dart
num numero = 3;
final decimale = numero as double;
```

Questo farà crashare il programma con il seguente errore:
> CastError (type 'int' is not a subtype of type 'double' in type cast)

Il tipo runtime di `numero` è `int` e non `double`. In Dart non puoi effettuare il casting con tipi allo stesso livello, come `int` e `double`. Puoi effettuare il casting solo per sotto tipi.

# --instructions--

Effettua il casting del tipo in modo da rendere la variable `number` di tipo intero e poter capire il numero è dispari.

# --seed--

```dart
const num number = 5;
final castedNum = [/][/][/];
print(castedNum.[/]);
```

# --answers--

- number
-  as 
- double
- String
- int
- isOdd
- isEven

# --solutions--

```dart
const num number = 5;
final castedNum = number as int;
print(castedNum.isOdd);
```

# --output--

true
