---
language: dart
exerciseType: 2
---

# --description--

In aggiunta a questi due modi di scrivere i commenti, Dart include i _commenti alla documentazione_.

I _commenti alla documentazione_ sono commenti su più righe o su una sola riga che iniziano con `///` o `/**.` L'uso di `///` su righe consecutive ha lo stesso effetto di un commento di documentazione su più righe.

I _commenti alla documentazione_ sono molto utili perché permettono di generare la documentazione. 
Vorrai aggiungere i _commenti alla documentazione_ al tuo codice per rendere chiaro che cosa fa un particolare blocco di codice.

All'interno di un _commento alla documentazione_, l'analyzer (analizzatore del codice) ignora tutto il testo a meno che non sia racchiuso in parentesi quadre.
Utilizzando le parentesi quadre ci si può riferire a _classi_, _metodi_, _campi_, _variabili_, _funzioni_ e _parametri_.

Ecco un esempio:
```dart
/// A domesticated South American camelid (Lama glama).
///
/// Just like any other animal, llamas need to eat,
/// so don't forget to [feed] them some [Food].
class Llama {
  String? name;

  /// Feeds your llama [food].
  ///
  /// The typical llama eats one bale of hay per week.
  void feed(Food food) {
    // ...
  }

  /// Exercises your llama with an [activity] for
  /// [timeLimit] minutes.
  void exercise(Activity activity, int timeLimit) {
    // ...
  }
}
```

Nella documentazione generata, `[feed]` diventa un link alla documentazione del metodo `feed` e `[Food]` diventa un link alla documentazione per la classe `Food`.
Mentre `[activity]` e `[timeLimit]` diventano un link alla documentazione dei parametri `activity` e `timeLimit` rispettivamente.

# --instructions--

Utilizza correttamente i _commenti alla documentazione_.

# --seed--

```dart
[/]
///
/// The [User] must always have a [name].
class User {
  [/]
  const User({
    required this.name,
  });

  [/]
  final String name;
}
```

# --answers--

- /// Identifies the user of the app.
- /// Constructor for creating a [User] with a given [name].
- /// Identifies the name of the user.
- /* Identifies the user of the app.
- /** Identifies the user of the app.
- // Identifies the user of the app.

# --solutions--

```dart
/// Identifies the user of the app.
///
/// The [User] must always have a [name].
class User {
  /// Constructor for creating a [User] with a given [name].
  const User({
    required this.name,
  });

  /// Identifies the name of the user.
  final String name;
}
```
