---
language: c
exerciseType: 2
---

# --description--

Spesso in programmazione, è necessario ripetere un blocco di codice, ad esempio:
```c
printf("2 secondi\n");
printf("3 secondi\n");
printf("4 secondi\n");
printf("5 secondi\n");
```
Questo produce il seguente output:
```c
2 secondi
3 secondi
4 secondi
5 secondi
```
Ovviamente, per lunghe dichiarazioni passeremmo molto tempo a scrivere il codice, ma fortunatamente possiamo usare i cicli.
Usiamo il ciclo `while`, in modo da ottenene lo stesso output di sopra.
```c
int contatore = 2;
while (contatore <= 5) {
    printf("%d secondi\n", contatore);
    contatore++;
}
```
Quindi abbiamo creato una variabile `contatore` assegnandole `2`, il valore iniziale.
Poi abbiamo usato la parola chiave `while` che eseguirà il blocco di codice finche' la condizione `contatore <= 5` e' `true`.
All'interno del blocco di codice, **NON** dovremo dimenticare la linea di codice `contatore++`.
In quanto incrementa il valore del `contatore`, altrimenti il nostro ciclo sarà infinito

# --instructions--

Riempire gli spazi vuoti con il ciclo `while` per ripetere il blocco di codice

# --seed--

```c
[/] (true) {
    printf("ripeti\n");
}
```

# --answers--

- while
- "while"
- for
- loop

# --solutions--

```c
while (true) {
    printf("ripeti\n");
}
```

# --output--

ripeti
ripeti
ripeti
ripeti
...
