Gli operatori vengono utilizzati per eseguire operazioni su variabili e valori.
Cominciamo con gli operatori aritmetici, in particolare con l'operatore dell' **addizione** `+`.
Serve a sommare due numeri, come:
```c
>>> 5 + 3
8
```

---

Continuiamo con l'operatore della **sottrazione** `-`.
Viene utilizzato per sottrarre un numero da un altro, come:
```c
>>> 5 - 3
2
```

---

Continuiamo con l'operatore della **moltiplicazione** `*`.
Viene utilizzato per moltiplicare due numeri insieme, come:
```c
>>> 5 * 3
15
```

---

Vediamo l'operatore della **divisione** `/`.
Viene utilizzato per dividere due numeri insieme, come:
```c
>>> 10 / 5
2
```

---

Vediamo l'operatore di **modulo** `%`.
Viene utilizzato per trovare il resto dopo una divisione tra due numeri, come:
```c
>>> 5 % 2
1
```
Il risultato e' uguale a 1 perche' 5 diviso 2 ha 2 come quoziente e 1 come resto.
```c
>>> 9 % 3
0
```
In questo caso il risultato e' uguale a 0 perche' 9 diviso 3 ha 3 come quoziente 3 e 0 come resto.

---

C non ha un operatore per l'elevamento a potenza, quindi dobbiamo usare la funzione `pow()` inclusa nella libreria `math.h`.
L'elevamento a potenza corrisponde alla moltiplicazione ripetuta della base: vale a dire **b** con esponente *n* e' il prodotto della moltiplicazione della base *n* volte:
![exponentiation](https://bit.ly/3zcz6Lt)
```c
>>> pow(5, 2);
25
```

---

Vediamo la **divisione floor**, chiamata anche *divisione intera*, utilizzando la funzione `floor()`.
Questa funzione restituisce la parte integrale del quoziente, ad esempio:
```c
>>> 5.0 / 2
2.5
>>> floor(2.5)
2.0
```
Il valore risultante e' un numero intero, sebbene il *tipo* del risultato non sia necessariamente `int`.
