---
language: swift
exerciseType: 1
---

# --description--

Variables are containers for storing data values.
Every variable in Swift is an object.
To create a variable, we need to give it a **name** keeping in mind that it must not contain spaces.
A variable is created the moment you first assign a value to it.
In Swift you declare constants with the `let` keyword and variables with the `var` keyword.
The value of a constant can't be changed once it's set, whereas a variable can be set to a different value in the future.
An example of a variable creation named `x` is:
```swift
var x = 1
```
In this way we have assigned the value `1` to the variable named `x`.
If we print the variable `x` we get back the number `1`:
```swift
print(x) // prints 1
```

# --instructions--

Assign to the variable `y` the value `2`.

# --before-asserts--

```swift
import Foundation
import XCTest

class CodigoTests: XCTestCase {
```

# --asserts--

`y` must be equal to `2`.

```swift
    func test1() {
        XCTAssertEqual(y, 2, "--err-t1--")
    }
```

# --after-asserts--

```swift
}

extension CodigoTests {
    static var allTests : [(String, (CodigoTests) -> () throws -> Void)] {
        return [
            ("test1", test1),
        ]
    }
}

XCTMain([testCase(CodigoTests.allTests)])
```

# --solutions--

```swift
var y = 2
```
