---
language: swift
exerciseType: 2
---

# --description--

A _variadic parameter_ accepts zero or more values of a specified type.
You use a variadic parameter to specify that the parameter can be passed a varying number of input values when the function is called.
Write variadic parameters by inserting three period characters `...` after the parameter's type name.
The values passed to a variadic parameter are made available within the function's body as an array of the appropriate type.
For example, a variadic parameter with a name of `numbers` and a type of `Double...` is made available within the function's body as a constant array called numbers of type `[Double]`

# --instructions--

Complete the code in order to calculate the average for the following list of numbers `1, 4, 6, 7, 9`

# --seed--

```swift
func average(_ numbers: [/][/]) -> Double {
    let total: Double = numbers.reduce(0, +)
    [/] total / Double(numbers.count)
}
print(average[/]1, 4, 6, 7, 9[/])
```

# --answers--

- Double
- "Double"
- double
- ...
- ..<
- (
- )
- return

# --solutions--

```swift
func average(_ numbers: Double...) -> Double {
    let total: Double = numbers.reduce(0, +)
    return total / Double(numbers.count)
}
print(average(1, 4, 6, 7, 9))
```

# --output--

5.4
