---
language: swift
exerciseType: 2
---

# --description--

You can use a tuple type as the return type for a function to return multiple values as part of one compound return value.

# --instructions--

Complete the code in order to create a valid function called `minMax` passing the following array of numbers `[15, 24, 31, 79, 44]`

# --seed--

```swift
func minMax(array: [Int]) -> [/]min: Int, max: Int[/] {
    var currentMin = array[0]
    var currentMax = array[0]
    array.forEach { num in
        if num < currentMin {
            currentMin = num
        } else if num > currentMax {
            currentMax = num
        }
    }
    return [/][/], [/][/]
}
let numbers: [Int] = [15, 24, 31, 79, 44]
print(minMax([/]: numbers))
```

# --answers--

- (
- )
- [
- ]
- {
- }
- (
- )
- array
- numbers
- currentMin
- currentMax

# --solutions--

```swift
func minMax(array: [Int]) -> (min: Int, max: Int) {
    var currentMin = array[0]
    var currentMax = array[0]
    array.forEach { num in
        if num < currentMin {
            currentMin = num
        } else if num > currentMax {
            currentMax = num
        }
    }
    return (currentMin, currentMax)
}
let numbers: [Int] = [15, 24, 31, 79, 44]
print(minMax(array: numbers))
```

# --output--

(min: 15, max: 79)
