---
language: swift
exerciseType: 2
---

# --description--

Functions can have multiple input parameters, which are written within the function's parentheses, separated by commas.
```swift
func sayHello(name: String, newUser: Bool) -> String {
  var greet: String = "Hello \(name)!"
  if (newUser) {
    greet += " Welcome on board :)"
  }
  return greet
}
// prints "Hello Smith! Welcome on board :)"
print(sayHello(name: "Smith", newUser: true))
```

# --instructions--

Complete the code in order to create a valid function called `sumAllNumbers` passing the following array of numbers `[15, 24, 31, 79]` and `true` to print the result

# --seed--

```swift
func sumAllNumbers(_ nums: [Int], _ printResult: Bool) -> Int {
    /* The reduce method is used to add up all the numbers, starting from 0 and using the + sign
    */
    let result = nums.reduce(0, +)
    if [/] { print(result) }
    return result
}
let result = [/]([/]15, 24, 31, [/][/], [/])
```

# --answers--

- sumAllNumbers
- sum
- 79
- ]
- [
- true
- false
- True
- printResult
- print
- true

# --solutions--

```swift
func sumAllNumbers(_ nums: [Int], _ printResult: Bool) -> Int {
    /* The reduce method is used to add up all the numbers, starting from 0 and using the + sign
    */
    let result = nums.reduce(0, +)
    if printResult { print(result) }
    return result
}
let result = sumAllNumbers([15, 24, 31, 79], true)
```

# --output--

149
