---
language: swift
exerciseType: 2
---

# --description--

In Swift we have also the `forEach` loop.
In fact, `forEach` calls the given closure on each element in the sequence in the same order as a `for-in` loop:
```swift
// this is an array, we'll see about that soon
let numbers: [Int] = [1, 3, 5, 7, 9] 
numbers.forEach { num in 
    print(num)
}
```
Using the `forEach` method is distinct from a `for-in` loop in two important ways:
1. The `break` or `continue` statement cannot be used to exit the current call of the body closure or to skip subsequent calls.
2. Using the `return` statement in the body closure will only exit the closure and not the outer scope, and it won't skip subsequent calls.

# --instructions--

Complete the code in order to print the following numbers `(3, 24, 9, 12, 18)` using a `forEach` loop

# --seed--

```swift
let numbers: [Int] = [3, 24, 9, 12, 18]
[/].[/] { [/] in
    print(num)
}
```

# --answers--

- for
- numbers
- forEach
- num

# --solutions--

```swift
let numbers: [Int] = [3, 24, 9, 12, 18]
numbers.forEach { num in
    print(num)
}
```

# --output--

3
24
9
12
18
