---
language: swift
exerciseType: 2
---

# --description--

For some enumerations, it's useful to have a collection of all of that enumeration's cases.
You enable this by writing `: CaseIterable` after the enumeration's name.
Swift exposes a collection of all the cases as an `allCases` property of the enumeration type:
```swift
enum Colors: CaseIterable {
    case blue, red, green
}
for color in Colors.allCases {
    print(color)
}
// prints blue, red, green
```

# --instructions--

Iterate over the enumeration in order to print each case.
`$0` is a shortand argument name which can be used to refer to the values of the closure's arguments.
`$0` refers to the closure's first argument, `$1` to the second argument, and so on

# --seed--

```swift
enum Week: [/] {
    case monday, tuesday, wednesday, thursday, friday, saturday, sunday
}
Week.[/].forEach { print($0) }
```

# --answers--

- CaseIterable
- caseIterable
- allCases
- AllCases
- all
- cases

# --solutions--

```swift
enum Week: CaseIterable {
    case monday, tuesday, wednesday, thursday, friday, saturday, sunday
}
Week.allCases.forEach { print($0) }
```

# --output--

monday
tuesday
wednesday
thursday
friday
saturday
sunday
