---
language: swift
exerciseType: 2
---

# --description--

We can match individual enumeration values with a `switch` statement:
```swift
let color = Colors.red
switch color {
    case .blue:
        print("Blue")
    case .red:
        print("Red")
    case .green:
        print("Green")
}
// prints "Red"
```
Keep in mind that if you don't need to provide a `case` for every enumeration case, you can provide a `default` case to cover any cases that aren't addressed explicitly

# --instructions--

Complete the `switch` statement in order to cover all cases

# --seed--

```swift
let currentDay = Week.monday
[/][/] {
    case .saturday, .[/]:
        print("Weekend")
    [/]:
        print("Working day")
}
```

# --answers--

- switch 
- currentDay
- sunday
- default

# --solutions--

```swift
let currentDay = Week.monday
switch currentDay {
    case .saturday, .sunday:
        print("Weekend")
    default:
        print("Working day")
}
```

# --output--

Working day
