---
language: swift
exerciseType: 2
---

# --description--

Because dictionaries are mutable, they can be changed in many ways. Items can be removed from a dictionary with the `removeValue(forKey:)` method:
```swift
if let removedValue = dictName.removeValue(forKey: "keyName") {
    print("The removed value is \(removedValue).") // prints the removed value, if the key exists
}
```
will remove the key `keyName` and its associated value from the dictionary.

# --instructions--

Delete the key `age` from the dictionary

# --seed--

```swift
var user: [String: Any] = ["first_name": "John", "last_name": "Hood", "age": 30]
if let removedValue = user.[/](forKey: [/]) {
    print("The removed value is \(removedValue)")
}
print(user)
```

# --answers--

- del 
- delete
- clear
- pop
- user
- "age"
- removeValue

# --solutions--

```swift
var user: [String: Any] = ["first_name": "John", "last_name": "Hood", "age": 30]
if let removedValue = user.removeValue(forKey: "age") {
    print("The removed value is \(removedValue)")
}
print(user)
```

# --output--

The removed value is 30
["first_name": "John", "last_name": "Hood"]
