---
language: swift
exerciseType: 2
---

# --description--

Like Arrays, Dictionaries are _mutable_.
This means they can be changed after they are created (if are not declared constant).
One advantage of this is that we can add new _key/value pairs_ to the dictionary after it is created like so:
```swift
dictName[newKeyName] = newValue
```

# --instructions--

Add one more _key-value pair_ to the `user` variable, with the name `"profession"` for the key and `"Developer"` as the value

# --seed--

```swift
var user: [String: Any] = ["first_name": "John", "last_name": "Hood", "age": 30]
[/][/][/][/] = [/]
if let profession = user["profession"] {
    print("The profession is \(profession)")
}
```

# --answers--

- user
- [
- ]
- "profession"
- "Developer"
- [3]

# --solutions--

```swift
var user: [String: Any] = ["first_name": "John", "last_name": "Hood", "age": 30]
user["profession"] = "Developer"
if let profession = user["profession"] {
    print("The profession is \(profession)")
}
```

# --output--

The profession is Developer
