---
language: swift
exerciseType: 2
---

# --description--

The _nil-coalescing operator_ `a ?? b` unwraps an optional `a` if it contains a value, or returns a default value `b` if `a` is `nil`.
The expression `a` is always of an optional type.
The expression `b` must match the type that is stored inside a.
The nil-coalescing operator is shorthand for the code below:
```swift
a != nil ? a! : b
```

# --instructions--

Use the _nil-coalescing operator_

# --seed--

```swift
var name: String? // name is nil
var greet: String = "Hello ";
greet += name [/] "World"
print(greet)
```

# --answers--

- if
- ==
- =
- else
- ?
- ??

# --solutions--

```swift
var name: String? // name is nil
var greet: String = "Hello ";
greet += name ?? "World"
print(greet)
```

# --output--

Hello World
