---
language: swift
exerciseType: 2
---

# --description--

The ternary conditional operator is a special operator with three parts, which takes the form `question ? answer1 : answer2`.
It's a shortcut for evaluating one of two expressions based on whether `question` is true or false.
If `question` is true, it evaluates `answer1` and returns its value; otherwise, it evaluates `answer2` and returns its value.
```swift
let a = 10, b = 20, c: Int
if (a < b) {
    c = a
} else {
    c = b
}
print(c)
```
The shortand code for the above code is:
```swift
let a = 10, b = 20, c: Int
c = a < b ? a : b
print(c)
```
`c` is set equal to `a`, because the condition `a < b` was true

# --instructions--

Create a valid ternary operator printing `"It's morning"` if the `time` is lower than `12`, otherwise `"It's afternoon"`

# --seed--

```swift
var time = 15
time < 12 [/] print("It's morning") [/] print("It's afternoon")
```

# --answers--

- if
- ==
- =
- else
- ?
- :

# --solutions--

```swift
var time = 15
time < 12 ? print("It's morning") : print("It's afternoon")
```

# --output--

It's afternoon
