---
language: swift
exerciseType: 2
---

# --description--

Structures and classes in Swift have many things in common. Both can:
- Define properties to store values
- Define methods to provide functionality
- Define subscripts to provide access to their values using subscript syntax
- Define initializers to set up their initial state
- Be extended to expand their functionality beyond a default implementation
- Conform to protocols to provide standard functionality of a certain kind

But classes have additional capabilities that structures don't have:
- Inheritance enables one class to inherit the characteristics of another
- Type casting enables you to check and interpret the type of a class instance at runtime
- Deinitializers enable an instance of a class to free up any resources it has assigned
- Reference counting allows more than one reference to a class instance

# --instructions--

Using the inheritance create a `Dog` class that inherits the `Animal` class

# --seed--

```swift
class Animal {
    var gender: String?
    var legs = 4
    func description() {
        if let gender = self.gender { print(gender) }
        print(self.legs)
    }
}
[/][/]: [/] {
    func speak() {
        print("Bau Bau!!")
    }
}
let dog = [/][/]
dog.gender = "female"
dog.description()
dog.speak()
```

# --answers--

- class 
- Dog
- Animal
- Dog
- ()
- Dog[]

# --solutions--

```swift
class Animal {
    var gender: String?
    var legs = 4
    func description() {
        if let gender = self.gender { print(gender) }
        print(self.legs)
    }
}
class Dog: Animal {
    func speak() {
        print("Bau Bau!!")
    }
}
let dog = Dog()
dog.gender = "female"
dog.description()
dog.speak()
```

# --output--

female
4
Bau Bau!!
