---
language: swift
exerciseType: 2
---

# --description--

Sometimes you need to search for an item in an array.
In Swift we can use the `firstIndex()` method:
```swift
var names: [String] = ["Trevor", "Zac", "Glenn"]
if let index = names.firstIndex(of: "Zac") {
  print(index)
}
// prints 1
```
The code above prints the first index that contains the string `"Zac"`, `1` in this case.
We can also insert items into an array in a specific index, using the `insert()` method:
```swift
names.insert("Ali", at: 1)
// prints ["Trevor", "Ali", "Zac", "Glenn"]
```
The code above inserts `"Ali"` at index `1`, which moves everything, after this index, down by 1

# --instructions--

- Use the `firstIndex()` method to print the index of `"dog"`.
- Then use the `insert()` method to add `"bear"` as first item of the array

# --seed--

```swift
var animals = ["cat", "monkey", "dog"]
if let i = animals.[/](of: [/]) {
    print(i)
}
animals.[/]("bear", at: [/])
print(animals)
```

# --answers--

- index
- firstIndex
- dog
- "dog"
- insert
- append
- add
- 0
- 1

# --solutions--

```swift
var animals = ["cat", "monkey", "dog"]
if let i = animals.firstIndex(of: "dog") {
    print(i)
}
animals.insert("bear", at: 0)
print(animals)
```

# --output--

2
["bear", "cat", "monkey", "dog"]
