---
language: swift
exerciseType: 2
---

# --description--

Sometimes, you only want to access a portion of an array.
Consider the following code:
```swift
let numbers = [1, 2, 3, 4]
let slice = numbers[1...2]
print(slice)
// prints [2, 3]
```
First, we create an array called `numbers`.
Then, we take a subsection of the array and store it in the slice array.
We do this by defining the indices we want to include after the name of the array: `numbers[1...2]`.
In Swift we can include the last index using `...`, but we can also exclude the last index using `..<`

# --instructions--

Create an array called `middle` containing only the two middle numbers from `numbers`

# --seed--

```swift
let numbers = [10, 5, 5, 5, 3, 2, 1, 0]
let middle = [/][[/][/][/]]
print(middle)
```

# --answers--

- numbers
- 2
- :
- 3
- -1
- 6
- 3
- 5
- ...
- ..<

# --solutions--

```swift
let numbers = [10, 5, 5, 5, 3, 2, 1, 0]
let middle = numbers[3..<5]
print(middle)
```

# --output--

[5, 3]
