---
language: python
exerciseType: 2
---

# --description--

Sometimes, you only want to access a portion of a list.
Consider the following code:
```python
>>> numbers = [1, 2, 3, 4]
>>> slice = numbers[1:3]
>>> print(slice)
[2, 3]
```
First, we create a list called `numbers`.
Then, we take a subsection of the list and store it in the slice list.
We do this by defining the indices we want to include after the name of the list: `numbers[1:3]`.
In Python, when we specify a portion of a list in this manner, we include the element with the first index, `1`, but we exclude the element with the second index, `3`.

# --instructions--

Create a list called `middle` containing only the two middle numbers from `numbers`

# --seed--

```python
numbers = [10, 5, 5, 5, 3, 2, 1, 0]
middle = [/][[/][/][/]]
print(middle)
```

# --answers--

- numbers
- 2
- :
- 3
- -1
- 4
- 3
- 5

# --solutions--

```python
numbers = [10, 5, 5, 5, 3, 2, 1, 0]
middle = numbers[3:5]
print(middle)
```

# --output--

[5, 3]
