We've already learned that to assign a value to a variable we can use the `=` sign, like:
```python
a = 5
```

---

We already have an initialized variable `total`
```python
total = 5
```
Let's say that we want to add the number `2` to the variable `total`, we can write
```python
total = total + 2
```
Okay, it works! But there is a shorter version to do the same thing:
```python
total += 2
```
The sign `+=` is called **addition assignment**.
It adds a value to the variable value and assigns the result to that variable.

---

Just like in the addition assignment, we have the **decrement assignment** `-=`.
The functionality is the same, the only difference is that it performs the subtraction.
So the followings are exactly the same
```python
num = num - 5
# is equal to
num -= 5
```

---

Let's see the **multiplication assignment** `*=` operator.
It multiplies the variable by a value and assigns the result to that variable.
So the followings are exactly the same
```python
num = num * 5
# is equal to
num *= 5
```

---

Let's see the **division assignment** `/=` operator.
It divides the variable by a value and assigns the result to that variable.
So the followings are exactly the same
```python
num = num / 5
# is equal to
num /= 5
```

---

Let's see the **power assignment** `**=` operator.
It raises the variable to a specified power and assigns the result to the variable.
So the followings are exactly the same
```python
num = num ** 5
# is equal to
num **= 5
```

---

Let's see the **modulus assignment** `%=` operator.
It computes the modulus of the variable and a value and assigns the result to that variable.
So the followings are exactly the same
```python
num = num % 5
# is equal to
num %= 5
```

---

Let's see the **floor assignment** `//=` operator.
It floor divides the variable by a value and assigns the result to that variable.
So the followings are exactly the same
```python
num = num // 5
# is equal to
num //= 5
```
