---
language: kotlin
exerciseType: 2
---

# --description--

The _while_ loop supports the three structural jump expression:
- `break` terminates the nearest enclosing loop.
- `continue` proceeds to the next step of the nearest enclosing loop.
- `return` by default returns from the nearest enclosing function or anonymous function (_we will see it later when we talk about functions_).

Here is an example of the use of `continue` within a _while_ loop:
```kotlin
var i = 0
while (i < 3) {
  i++
  if (i == 2) continue // [1]
  println(i)
}
// prints 1, 3
```

As you can see at __[1]__ when `i` is equal to _2_, we skip and _continue_ to the next step. In fact the number 2 is never printed.

# --instructions--

Fill in the blanks with the `while` loop and skip it when `n` is _even_.

# --seed--

```kotlin
var n = 0
[/] {
  n++
  if (n[/]2[/]0) [/]
  println(n)
} [/] (n < 10)
```

# --answers--

-  % 
-  // 
-  / 
-  == 
-  != 
- break
- continue
- while
- do
- do-while
- until


# --solutions--

```kotlin
var n = 0
do {
  n++
  if (n % 2 == 0) continue
  println(n)
} while (n < 10)
```

# --output--

1
3
5
7
9
