---
language: kotlin
exerciseType: 2
---

# --description--

There's a second way to use _while_, in conjuction with the `do` keyword.
```kotlin
do {
  // Code to be repeated
} while (Boolean-expression)
```
As you can see the `do-while` is pretty similar to the `while` loop, except for one important difference:
> the body of the loop is executed once before the condition is evaluated.

In other words, the body of the `do-while` always executes at least once, even if the condition expression initially produces `false`.

In constrast, the body of a `while` loop will never run if the condition produces `false` the first time.

# --instructions--

Fill in the blanks with the `do-while` loop to repeat the block of code in order to print the first 10 multiples of _3_.

# --seed--

```kotlin
var counter = 1
do {
    println([/] * 3)
    counter[/]
} while (counter[/]10)
```

# --answers--

- while
- "while"
- counter
- loop
-  <= 
-  < 
- for
-  * 
-  ** 
- ++


# --solutions--

```kotlin
var counter = 1
do {
    println(counter * 3)
    counter++
} while (counter <= 10)
```

# --output--

3
6
9
12
15
18
21
24
27
30
