---
language: kotlin
exerciseType: 2
---

# --description--

> Computers are ideal for repetitive tasks.

The most basic form of repetition uses the `while` keyword.
This repeats a block as long as the controlling _Boolean expression_ is true:

```kotlin
while (Boolean-expression) {
  // Code to be repeated
}
```
The Boolean expression is evaluated once at the beginning of the loop and
again before each further iteration through the block.

```kotlin
var x = 3
while (x > 0) {
    println(x)
    x--
}
```
Here we've created a variable `x`, assigning it the initial value of __3__.

Then we have used the `while` statement that will run the block of code until the condition `x > 0` is `true`.

Inside the block of code, we should **NOT** miss to add the line `x--`.
It decrements the `x` value, otherwise, our loop will be infinite.

# --instructions--

Fill in the blanks with the `while` loop to repeat the block of code.

> Don't worry if this is an infinite loop

# --seed--

```kotlin
[/] (true) {
    println("repeat")
}
```

# --answers--

- while
- "while"
- for
- loop

# --solutions--

```kotlin
while (true) {
    println("repeat")
}
```

# --output--

repeat
repeat
repeat
repeat
...
