---
language: kotlin
exerciseType: 1
---

# --description--

Variables are containers for storing data values.
Every variable in Kotlin is an object.
To create a variable, we need to give it a __name__ keeping in mind that it must not contain spaces.
A variable is created the moment you first assign a value to it.
In Kotlin you declare constants with the `val` (short for _value_) keyword and variables with the `var` (short for _variable_) keyword.
The value of a constant can't be changed once it's set, whereas a variable can be set to a different value in the future.
An example of a variable creation named `x` is:
```kotlin
var x = 1
```
In this way we have assigned the value `1` to the variable named `x`.
If we print the variable `x` we get back the number `1`:
```kotlin
println(x) // prints 1
```

# --instructions--

Assign to the variable `y` the value `2`.

# --before-seed--

```kotlin
// DO NOT EDIT FROM HERE
var _testFailedCount = 0;
var _testCount = 0;
fun tryCatch(assertion: Boolean) {
  _testCount++
    try { 
        if (!assertion) throw Exception()
    }
    catch (e: Throwable) {
        _testFailedCount++
        println("Test Case '--err-t$_testCount--' failed");
  }
};
// DO NOT EDIT UNTIL HERE
fun main() {
```

# --asserts--

`y` must be equal to `2`.

```kotlin
    tryCatch(y == 2)
```

# --after-asserts--

```kotlin
// DO NOT EDIT FROM HERE 
    println("Executed $_testCount tests, with $_testFailedCount failures");
}
// DO NOT EDIT UNTIL HERE
```

# --solutions--

```kotlin
var y = 2
```
