---
language: kotlin
exerciseType: 2
---

# --description--

There are two types of `Set`s in Kotlin:

- `Set` cannot be modified after you create it.
- `MutableSet` can be modified after you create it, meaning you can add, remove, or update its elements.

```kotlin
val numbers = setOf(1, 2, 3)
numbers.add(4) // [1]
```
__[1]__ throws an Error because `Set`s are _read-only_.

To create a modifiable set use the `mutableSetOf` keyword
```kotlin
val numbers = mutableSetOf(1, 2, 3)
numbers.add(4)
println(numbers)
// prints [1, 2, 3, 4]
```

# --instructions--

Complete the code in order to create a valid modifiable set

# --seed--

```kotlin
val [/] = [/]<String>[/]"apple", "banana"[/]
fruits.add("mango")
println(fruits)
```

# --answers--

- fruits
- "fruits"
- [
- ]
- (
- )
- listOf
- setOf
- mutableListOf
- mutableSetOf

# --solutions--

```kotlin
val fruits = mutableSetOf<String>("apple", "banana")
fruits.add("mango")
println(fruits)
```

# --output--

[apple, banana, mango]
