---
language: kotlin
exerciseType: 2
---

# --description--

`Set`s are a datatype you can use to store a collection of different pieces of information as a sequence under a single variable name.
The main difference with `List`s is that a `Set` allows only one element of each value.

Like `List`s, a `Set` stores multiple values of one or multiple types and uses **indexes** to distinguish these values.
You can assign items to a set with an expression of the form:
```kotlin
val setName = setOf<itemsType>(item1, item2)
```
`itemsType` stands for the type of the items inside the set, for example, it can be `Int`, `String`, `Any`...

# --instructions--

Complete the code in order to create a valid set

# --seed--

```kotlin
val [/] = [/]<Int>[/]1, 2, 3[/]
for (num in numbers) {
    println(num)
}
```

# --answers--

- numbers
- "numbers"
- [
- ]
- (
- )
- listOf
- setOf

# --solutions--

```kotlin
val numbers = setOf<Int>(1, 2, 3)
for (num in numbers) {
    println(num)
}
```

# --output--

1
2
3
