---
language: kotlin
exerciseType: 2
---

# --description--

Sometimes, you only want to access a portion of a list.
Consider the following code:
```kotlin
val numbers = listOf(1, 2, 3, 4) // [1]
val slice = numbers.slice(1..2) // [2]
println(slice)
// prints [2, 3]
```
__[1]__: first, we create a _read-only_ list called `numbers`.
__[2]__: then, we take a subsection of the list using the `slice` function and store it in the slice list.
We do this by defining the indices we want to include inside the `slide` function.

In Kotlin we can include the last index using `..`, but we can also exclude the last index using `until`

# --instructions--

Create a list called `middle` containing only the two middle numbers from `numbers`

# --seed--

```kotlin
val numbers = listOf(10, 5, 5, 5, 3, 2, 1, 0)
val middle = [/].[/]([/][/][/])
println(middle)
```

# --answers--

- numbers
- slice
-  until 
- 2
- :
- 3
- -1
- 6
- 3
- 5
- ...
- ..<

# --solutions--

```kotlin
val numbers = listOf(10, 5, 5, 5, 3, 2, 1, 0)
val middle = numbers.slice(3 until 5)
println(middle)
```

# --output--

[5, 3]
