---
language: kotlin
exerciseType: 2
---

# --description--

The index is actually an offset from the first element. For example, when you say `list[2]` you are not asking for the second element of the list, but for the element that is 2 positions offset from the first element. Hence `list[0]` is the first element (zero offset), `list[1]` is the second element (offset of 1), `list[2]` is the third element (offset of 2), and so on.

A list index can be used to access as well as assign values.
You saw how to access a list index like this:
```kotlin
val names = mutableListOf("Jeremiah", "Barney", "Ivan", "Noel"]
// Prints the value "Jeremiah"
println(names[0])
```
This is how an assignment works:
```kotlin
val names = mutableListOf("Jeremiah", "Barney", "Ivan", "Noel")
// Assign the new value "Jordan"
names[0] = "Jordan"
// Prints the value "Jordan"
println(names[0])
```

# --instructions--

Complete the code in order to replace the item that currently holds the value `"Mia"` with the name `"Sophie"`

# --seed--

```kotlin
val names = mutableListOf("Charlotte", "Mia", "Jessica", "Hollie")
[/][/][/]"Sophie"
println(names)
```

# --answers--

- [0]
- [1]
- [2]
- [3]
- [4]
-  = 
- names

# --solutions--

```kotlin
val names = mutableListOf("Charlotte", "Mia", "Jessica", "Hollie")
names[1] = "Sophie"
println(names)
```

# --output--

[Charlotte, Sophie, Jessica, Hollie]
