---
language: kotlin
exerciseType: 2
---

# --description--

A list is a collection of items with a specific order. There are two types of lists in Kotlin:

- `List` cannot be modified after you create it.
- `MutableList` can be modified after you create it, meaning you can add, remove, or update its elements.

```kotlin
val numbers = listOf(1, 3, 5)
numbers.add(7) // [1]
```
__[1]__ throws an Error because `List`s are _read-only_.

To create a modifiable list use the `mutableListOf` keyword
```kotlin
val numbers = mutableListOf(1, 3, 5)
numbers.add(7)
println(numbers)
// prints [1, 3, 5, 7]
```

# --instructions--

Complete the code in order to create a valid modifiable list

# --seed--

```kotlin
val [/] = [/]<String>[/]"apple", "banana"[/]
fruits.add("mango")
println(fruits)
```

# --answers--

- fruits
- "fruits"
- [
- ]
- (
- )
- listOf
- mutableListOf

# --solutions--

```kotlin
val fruits = mutableListOf<String>("apple", "banana")
fruits.add("mango")
println(fruits)
```

# --output--

[apple, banana, mango]
