---
language: kotlin
exerciseType: 2
---

# --description--

Sometimes you need to search for an item in a list.
In Kotlin we can use the `indexOfFirst` method:
```kotlin
val names = mutableListOf("Trevor", "Zac", "Glenn")
println(names.indexOfFirst { it == "Zac"})
// prints 1
```

The `indexOfFirst` method takes a __predicate__ function that will be evaluated for each item in the list until it's true, returning the _index_ of the element.
The code above prints the first index that contains the string `"Zac"`, `1` in this case.

We can also insert items into a modifiable list in a specific index, using the `add(index, element)` method:
```kotlin
names.add(1, "Ali")
// prints [Trevor, Ali, Zac, Glenn]
```
The code above inserts `"Ali"` at index `1`, which moves everything, after this index, down by 1

# --instructions--

- Use the `indexOfFirst` method to print the index of `"dog"`.
- Then use the `add` method to add `"bear"` as first item of the list

# --seed--

```kotlin
val animals = mutableListOf("cat", "monkey", "dog")
println(animals.[/] { it == [/]})
animals.[/]([/], "bear")
println(animals)
```

# --answers--

- index
- indexOfFirst
- dog
- "dog"
- insert
- append
- add
- 0
- 1

# --solutions--

```kotlin
val animals = mutableListOf("cat", "monkey", "dog")
println(animals.indexOfFirst { it == "dog"})
animals.add(0, "bear")
println(animals)
```

# --output--

2
[bear, cat, monkey, dog]
