---
language: kotlin
exerciseType: 2
---

# --description--

In Kotlin we have also the `forEach` loop.
It calls the given closure on each element in the sequence in the same order as a `for-in` loop:

```kotlin
// this is a list, we'll see about that soon
val numbers = listOf(1, 3, 5, 7, 9) 
numbers.forEach {
    println(it)
}
```

Using the `forEach` method is distinct from a `for-in` loop in two important ways:
1. The `break` or `continue` statement cannot be used to exit the current call of the body closure or to skip subsequent calls. (_Actually it is possible with annotations, but it's a bit more complex topic that we won't see now._)
2. Using the `return` statement in the body closure will only exit the closure and not the outer scope, and it won't skip subsequent calls.

# --instructions--

Complete the code in order to print the following numbers `(3, 24, 9, 12, 18)` using a `forEach` loop

# --seed--

```kotlin
val numbers = listOf(3, 24, 9, 12, 18) 
[/].[/] {
    println([/])
}
```

# --answers--

- for
- numbers
- forEach
- num
- it

# --solutions--

```kotlin
val numbers = listOf(3, 24, 9, 12, 18) 
numbers.forEach {
    println(it)
}
```

# --output--

3
24
9
12
18
