---
language: kotlin
exerciseType: 2
---

# --description--

The default _step_ of a range is __1__, but you can explicitly set another value.

You can define the __step__ of your `for` loop using the `step` keyword.

```kotlin
for (i in 1..10 step 2) {
    println(i)
}
// prints 1, 3, 5, 7, 9
```

As you can see, the code-block runs with a step of _2_ instead of _1_, changing completely our output.

# --instructions--

Complete the `for` loop in the following code in order to obtain this output: `10, 8, 6, 4, 2`

# --seed--

```kotlin
for (i in 10 [/] 1 [/] 2) {
    println(i)
}
```

# --answers--

- loop
-  until 
- ..
- ..<
- downTo
- step

# --solutions--

```kotlin
for (i in 10 downTo 1 step 2) {
    println(i)
}
```

# --output--

10
8
6
4
2
