---
language: kotlin
exerciseType: 2
---

# --description--

You can iterate over a range in reverse order.

You will probably expect `3..1` to work, unfortunately, the Kotlin team has decided to import this functionality in a different way.

In fact if you try to run this snippet of code:
```kotlin
for (i in 3..1) println(i)
```

You'll see that nothing is printed.
To make it working we've to use the `downTo` keyword:

```kotlin
for (i in 3 downTo 1) println(i)
// prints 3, 2, 1
```

`downTo` produces a decreasing range.

# --instructions--

Complete the `for` loop in the following code in order to print numbers from _10_ to _1_.

# --seed--

```kotlin
[/] (i in 10 [/] 1) {
    println(i)
}
```

# --answers--

- while
- for
- loop
-  until 
- ..
- ..<
- downTo

# --solutions--

```kotlin
for (i in 10 downTo 1) {
    println(i)
}
```

# --output--

10
9
8
7
6
5
4
3
2
1
