---
language: kotlin
exerciseType: 2
---

# --description--

A _range_ is an interval of values defined by a pair of endpoints.
There are two basic ways to define ranges:

```kotlin
var firstRange = 1..3           // [1]
var secondRange = 1 until 3     // [2]
println(firstRange)
println(secondRange)

/* prints
1..3
1..2
*/
```

- __[1]__ using the `..` syntax includes both bounds in the resulting range.
- __[2]__ `until` excludes the end. The output shows that _3_ is not part of the range.

# --instructions--

Complete the `for` loop in the following code in order to print numbers from _1_ to _3_.

# --seed--

```kotlin
[/] (i in 1[/]4) {
    println(i)
}
```

# --answers--

- while
- "while"
- for
- loop
- "for"
-  until 
- ..
- ..<

# --solutions--

```kotlin
for (i in 1 until 4) {
    println(i)
}
```

# --output--

1
2
3
