---
language: kotlin
exerciseType: 2
---

# --description--

> The `for` keyword executes a block of code for each value in a sequence.

The `for` loop iterates through anything that provides an iterator.

The syntax of `for` is the following:
```kotlin
for (item in collection) print(item)
```

The body of `for` can also be a block
```kotlin
for (item in collection) {
    print(item)
}
```

Each time through the loop, `item` is given the next element in values.

Here's a `for` loop repeating an action a fixed number of times:

```kotlin
for (i in 1..3) {
    println(i)
}
// prints 1, 2, 3
```

The output shows the index `i` receiving each value in the range from _1_ to _3_.

# --instructions--

Complete the `for` loop in the following code

# --seed--

```kotlin
[/] (i in 1..4) {
    println("repeat")
}
```

# --answers--

- while
- "while"
- for
- loop
- "for"

# --solutions--

```kotlin
for (i in 1..4) {
    println("repeat")
}
```

# --output--

repeat
repeat
repeat
repeat
