---
language: kotlin
exerciseType: 2
---

# --description--

The _elvis operator_ `a ?: b` unwraps an optional `a` if it contains a value, or returns a default value `b` if `a` is `null`.
The expression `a` is always of an optional type.
The expression `b` must match the type that is stored inside a.
The elvis operator is shorthand for the code below:
```kotlin
if (a != null) a else b
```

# --instructions--

Use the _elvis operator_

# --seed--

```kotlin
var name: String? = null
var greet: String = "Hello "
greet += name [/] "World"
println(greet)
```

# --answers--

- if
- ==
- =
- else
- ?
- ??
- ?:

# --solutions--

```kotlin
var name: String? = null
var greet: String = "Hello "
greet += name ?: "World"
println(greet)
```

# --output--

Hello World
