---
language: javascript
exerciseType: 2
---

# --description--

Often in programming, we need to repeat a block of code, for example:
```javascript
console.log("2 seconds");
console.log("3 seconds");
console.log("4 seconds");
console.log("5 seconds");
```
This produces the following output:
```javascript
2 seconds
3 seconds
4 seconds
5 seconds
```
Obviously, for long statements we would spend a lot of time writing the code, but fortunately, we can use loops.
Let's learn the `while` loop, getting the same output above.
```javascript
var count = 2;
while (count <= 5) {
    console.log(`${count} seconds`);
    count += 1;
}
```
So we created a variable `count` assigning `2`, the initial value.
Then we have used the `while` statement that will run the block of code until the condition `count <= 5` is `true`.
Inside the block of code, we should **NOT** miss to add the line `count += 1`.
It increments the `count` value, otherwise, our loop will be infinite

# --instructions--

Fill in the blanks with the `while` loop to repeat the block of code

# --seed--

```javascript
[/] (true) {
    console.log("repeat");
}
```

# --answers--

- while
- "while"
- for
- loop

# --solutions--

```javascript
while (true) {
    console.log("repeat");
}
```

# --output--

repeat
repeat
repeat
repeat
...
