---
language: javascript
exerciseType: 2
---

# --description--

As for arrays, we can loop between dictionary elements using the `Object.entries()` method.
```javascript
var user = {"first_name": "John", "last_name": "Hood", "age": 30};
for (const [key, value] of Object.entries(user)) {
    console.log(`${key}: ${value}`);
}
```

# --instructions--

Loop through the dictionary items

# --seed--

```javascript
var user = {"first_name": "John", "last_name": "Hood", "age": 30};
[/] (const [[/], [/]] of Object.[/](user)) {
  console.log(`${key}: [/]`);
}
```

# --answers--

- key
- value
- value
- user
- "user"
- \(value)
- ${value}
- entries
- for

# --solutions--

```javascript
var user = {"first_name": "John", "last_name": "Hood", "age": 30};
for (const [key, value] of Object.entries(user)) {
  console.log(`${key}: ${value}`);
}
```

# --output--

first_name: John
last_name: Hood
age: 30
